﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using DataAccess;

public partial class TBICDSHome : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            Master.ClosePatient();
            ShowSysFeedback();
        }
    }

    /// <summary>
    /// Does the user have the provider key
    /// </summary>
    /// <returns></returns>
    protected bool HasProviderKey()
    {
        CMDWSOps ops = new CMDWSOps(Master.GetDataObject());
        CStatus status = ops.HasSecurityKey(CDataUtils2.ToLong(Master.DUZ), "PROVIDER");

        if (status.StatusCode == k_STATUS_CODE.Failed)
        {
            return false;
        }

        return true;
    }


    protected void ShowSysFeedback()
    {
        if (Master.StatusCode > 0 && !String.IsNullOrEmpty(Master.StatusComment))
        {
            HtmlContainerControl div = (HtmlContainerControl)this.Master.FindControl("divSysFeedback");
            div.InnerHtml = Master.StatusComment;
            ScriptManager.RegisterStartupScript(this.Page, typeof(string), "showAlert", "Ext.onReady(function(){ var winSysFeedback = Ext.getCmp('winSysFeedback'); if(typeof(winSysFeedback) === 'object'){ winSysFeedback.show(); } });", true);
            Master.ClearStatus();
        }
    }
}